// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     chrome/browser/media/router/media_router.mojom
//

package org.chromium.mojom.media_router.interfaces;

public final class MediaRoute extends org.chromium.mojo.bindings.Struct {

    private static final int STRUCT_SIZE = 56;
    private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(56, 0)};
    private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

    public String mediaRouteId;
    public String mediaSource;
    public String mediaSinkId;
    public String description;
    public boolean isLocal;
    public String customControllerPath;
    public boolean forDisplay;

    private MediaRoute(int version) {
        super(STRUCT_SIZE, version);
    }

    public MediaRoute() {
        this(0);
    }

    public static MediaRoute deserialize(org.chromium.mojo.bindings.Message message) {
        return decode(new org.chromium.mojo.bindings.Decoder(message));
    }

    @SuppressWarnings("unchecked")
    public static MediaRoute decode(org.chromium.mojo.bindings.Decoder decoder0) {
        if (decoder0 == null) {
            return null;
        }
        org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
        MediaRoute result = new MediaRoute(mainDataHeader.elementsOrVersion);
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.mediaRouteId = decoder0.readString(8, false);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.mediaSource = decoder0.readString(16, true);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.mediaSinkId = decoder0.readString(24, false);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.description = decoder0.readString(32, false);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.isLocal = decoder0.readBoolean(40, 0);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.forDisplay = decoder0.readBoolean(40, 1);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.customControllerPath = decoder0.readString(48, true);
        }
        return result;
    }

    @SuppressWarnings("unchecked")
    @Override
    protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
        org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        encoder0.encode(mediaRouteId, 8, false);
        encoder0.encode(mediaSource, 16, true);
        encoder0.encode(mediaSinkId, 24, false);
        encoder0.encode(description, 32, false);
        encoder0.encode(isLocal, 40, 0);
        encoder0.encode(forDisplay, 40, 1);
        encoder0.encode(customControllerPath, 48, true);
    }

    /**
     * @see Object#equals(Object)
     */
    @Override
    public boolean equals(Object object) {
        if (object == this)
            return true;
        if (object == null)
            return false;
        if (getClass() != object.getClass())
            return false;
        MediaRoute other = (MediaRoute) object;
        if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.mediaRouteId, other.mediaRouteId))
            return false;
        if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.mediaSource, other.mediaSource))
            return false;
        if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.mediaSinkId, other.mediaSinkId))
            return false;
        if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.description, other.description))
            return false;
        if (this.isLocal != other.isLocal)
            return false;
        if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.customControllerPath, other.customControllerPath))
            return false;
        if (this.forDisplay != other.forDisplay)
            return false;
        return true;
    }

    /**
     * @see Object#hashCode()
     */
    @Override
    public int hashCode() {
        final int prime = 31;
        int result = prime + getClass().hashCode();
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(mediaRouteId);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(mediaSource);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(mediaSinkId);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(description);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(isLocal);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(customControllerPath);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(forDisplay);
        return result;
    }
}

